import torch
import os
import Config
from utils.reprod_setup import device
import time

def load_from_disk(model_path, device):

    return torch.load(model_path, map_location=device)


def save_to_disk(model_dir, status):

    os.makedirs(model_dir, exist_ok=True)
    path = os.path.join(model_dir, time.strftime('%d%y%h_%H%M%S')+'.pt')
    torch.save(status, path)
    return path